<?php
defined( '_JEXEC' ) or die( 'Restricted index access' );

jimport('joomla.filesystem.file');
require_once(JPATH_ROOT."/templates/{$this->template}/lib/php/cache.php");

// remove mootools.js and caption.js
$scriptCount = 0;
$reqScripts = array();

$headerjs = $this->getHeadData();

reset($headerjs['scripts']);

foreach ($headerjs['scripts'] as $script=>$type) {
	if(strstr($script,'mootools.js') || strstr($script,'caption.js'))
	{
        unset($headerjs['scripts'][$script]);
	}
	else
	{
		$reqScripts[$scriptCount] = $script;
		$scriptCount = $scriptCount + 1;
		unset($headerjs['scripts'][$script]);
	}
}

//Are we in edit mode
$editmode = false;
if (JRequest::getCmd('task') == 'edit' ) :
	$editmode = true;
endif;

//DEFINE THE JAVASCRIPTS TO INCLUDE ADN TEMPLATE PARAMS SET
$template_width 		= $this->params->get("templateWidth", "960");
$mootools_enabled       = ($this->params->get("mootools_enabled", 1)  == 0)?"false":"true";
$caption_enabled        = ($this->params->get("caption_enabled", 1)  == 0)?"false":"true";
$jQuery_enabled      	= ($this->params->get("jQuery_enabled", 1)  == 0)?"false":"true";
$crosslide_enabled      = ($this->params->get("crosslide_enabled", 0)  == 0)?"false":"true";
$toggler_enabled        = ($this->params->get("toggler_enabled", 0)  == 0)?"false":"true";
$dropdownmenu_enabled   = ($this->params->get("dropdownmenu_enabled", 0)  == 0)?"false":"true";
$accordeonmenu_enabled  = ($this->params->get("accordeonmenu_enabled", 0)  == 0)?"false":"true";
$scrollpanel_enabled    = ($this->params->get("scrollpanel_enabled", 0)  == 0)?"false":"true";
$scrolled_name 			= $this->params->get("scrolled_name", "scrolled_content");
$dropdown_width 		= $this->params->get("dropdown_width", "200");
$compression 			= $this->params->get('compression');
$GLOBALS['siteLogo']	= $this->params->get('siteLogo');

//ADDING THE PAGE SUFFIX ON THE CONTENTS CLASSES
$itemid = JRequest::getVar('Itemid');
$menu = &JSite::getMenu();
$active = $menu->getItem($itemid);
$params = $menu->getParams( $active->id );
$pageclass = $params->get( 'pageclass_sfx' );

//SETTING THE META ON THE LOGO
$mydoc =& JFactory::getDocument();

if ($GLOBALS['myLogoAlt'] == '' )
{
	$GLOBALS['myLogoAlt'] = $GLOBALS['myPageDesc'];
	$GLOBALS['myPageTitle'] = $mydoc->getTitle().$GLOBALS['myPageTitle'];
}
//$myPageTitle = $mydoc->getTitle();
//$myLogoAlt = $mydoc->getMetaData( "keywords" );
	
	$langObj=JFactory::getLanguage();
	$langTag=$langObj->getTag();		
	$langArr=explode("-", $langTag); //el-GR
	
	if (count($langArr)>0){
		$lang =	$langArr[0];
	}

//SETTING THE REQUIRED TO HEADER JAVASCRIPT
if ($jQuery_enabled == "true")
{
	$headerjs['scripts'][$this->baseurl.'/templates/startup/js/jquery-1.5.2.min.js'] = 'text/javascript';
	$headerjs['scripts'][$this->baseurl.'/templates/startup/js/jquery.no.conflict.js'] = 'text/javascript';
}

if ($mootools_enabled == "true")
{
	$headerjs['scripts'][$this->baseurl.'/templates/startup/js/mootools.js'] = 'text/javascript';
}

if ($caption_enabled == "true")
{
	$headerjs['scripts'][$this->baseurl.'/templates/startup/js/caption.js'] = 'text/javascript';
}

for($scriptCount=0; $scriptCount < sizeof($reqScripts); $scriptCount += 1)

{
	$headerjs['scripts'][$reqScripts[$scriptCount]] = 'text/javascript';
}

$this->setHeadData($headerjs);

////LOADING THE EXTRA JAVASCRIPTS
if ($crosslide_enabled == "true")
{
	$this->addScript($this->baseurl.'/templates/startup/js/jquery.cross-slide.js');
}

if ($toggler_enabled == "true")
{
	$this->addScript($this->baseurl.'/templates/startup/js/jquery.toggler.js');
	$this->addStyleSheet($this->baseurl.'/templates/startup/css/toggler.css');
}

if ($dropdownmenu_enabled == "true")
{
	$this->addScript($this->baseurl.'/templates/startup/js/dropdownmenu.js');
}

if ($accordeonmenu_enabled == "true")
{
	$this->addScript($this->baseurl.'/templates/startup/js/accordionmenu.js');
}

if ($scrollpanel_enabled == "true")
{
	$this->addStyleSheet($this->baseurl.'/templates/startup/css/jScrollPane.css');
	$this->addScript($this->baseurl.'/templates/startup/js/jScrollPane-1.2.3.min.js');
	$this->addScript($this->baseurl.'/templates/startup/js/jquery.mousewheel.min.js');
	$this->addScriptDeclaration(startScroller($scrolled_name));
}

$this->addScript($this->baseurl.'/templates/startup/js/on_DOM_ready.js');


//SETTING THE WRAPPER CSS
$inlinestyle = '#wrapper { width: ' . $template_width . ';}';
$this->addStyleDeclaration($inlinestyle);



//SETTING THE DROPDOWN MENU CSS
$inlinestyle = '#navigation .dropdown { width: '.intval($dropdown_width)."px;}\n";
$inlinestyle .= '#navigation .columns2 { width: '.(2*intval($dropdown_width))."px; }\n";
$inlinestyle .= '#navigation .columns3 { width: '.(3*intval($dropdown_width))."px; }\n";
$inlinestyle .= '#navigation .columns4 { width: '.(4*intval($dropdown_width))."px; }\n";

$this->addStyleDeclaration($inlinestyle);

$this->addStyleSheet($this->baseurl.'/templates/startup/css/styles.css');

// stylesheet/script compression & caching
if ($compression != 0) {
$gzip = $compression == 2;
$rule = new CacheRule('/^.*\/templates\/startup\/.*$/');
$stylesheet = new CacheStylesheet($this);
$stylesheet->addRule($rule);
$stylesheet->process($gzip);
$script = new CacheScript($this);
$script->addRule($rule);
$script->process($gzip);
}

//START SCROLLED CONTENT FUNCTION
function startScroller($scrolled_name) {
	$javascript ='jQuery(document).ready(function($){' . "\n";
	$javascript .= '<!-- initiate the jQuery scroller if needed on dom ready -->' . "\n";
	$javascript .= 'if (jQuery("#'.$scrolled_name.'")) {' . "\n";
	$javascript .= 'jQuery(function(){' . "\n";
	$javascript .= 'jQuery("#'.$scrolled_name.'").jScrollPane();' . "\n";
	$javascript .= '});	' . "\n";
	$javascript .= '}' . "\n";
	$javascript .= '});';
	return $javascript;
}

?>