(function($){

$.Controller(
	'EasyBlog.FileManager.Toolbar.Pathway',
	{
		defaults: {
			"{pathwayNav}"        : '.pathway-nav',
			"{pathwayItem}"       : '.pathway-item',
			"{folderName}"        : '#folder-name',
			"{createFolderForm}"  : '.create-folder-form',
			"{createFolderToggle}": '.create-folder-toggle',
			"{createFolderButton}": '.create-folder-button',
			"@pathwayItem": 'EasyBlog.FileManager.Toolbar.Pathway.Item'
		}
	},
	function(self) { return {

		init: function()
		{
			self.fileManager = self.options.fileManager;

			var path = self.fileManager.options.path;
			self.generatePath(path);
		},
		
		generatePath: function(rawPath)
		{			
			var paths = rawPath.split('/');
			
			// if (rawPath=='') return;
			
			$.each(paths, function(i, path)
			{
				// TODO: Double check if '/' forward slash is URL safe.
				$.View(
					self.template('pathwayItem'),
					{
						folder: paths.slice(1,i+1).join('/'),
						folderName: path || '/'
					},
					function(html)
					{ 
						self.pathwayNav()
							.append(html);
					}
				);
			});

			self.pathwayItem(':last')
				.addClass('active');
		},

		setLayout: function()
		{
			// TODO: Scrollable pathway
		},

		createFolder: function()
		{
			var folderName = self.folderName().val();

			if ($.trim(folderName)=='') return;			

			self.folderName().attr('disabled', true);

			self.fileManager.browser.setContentPaneMessage($.lang('COM_EASYBLOG_CREATING_FOLDER') + ' "' + folderName + '"...');

			self.fileManager.operations.createFolder(
				folderName,
				{
					success: function(folderItem)
					{
						self.fileManager.browser.setContentPaneMessage($.lang('COM_EASYBLOG_FOLDER_CREATED') + ' "' + folderName + '"!', 'topAndFade');

						// Append newly created folders
						self.fileManager.browser.addItem(folderItem, function(item)
						{
							self.fileManager.browser.gotoItem( item );
						});

						self.folderName().attr('disabled', false);
						
						self.createFolderForm().removeClass('active');
					},

					error: function(msg)
					{
						self.fileManager.browser.setContentPaneMessage($.lang('COM_EASYBLOG_ERROR_CREATING_FOLDER') + ' "' + folderName + '"! ' + msg, 'topAndFade');

						self.folderName().attr('disabled', false);
					}
				}
			);
		},

		"{createFolderToggle} click": function(el)
		{
			self.createFolderForm()
				.toggleClass('active');

			if (self.createFolderForm().hasClass('active'))
			{
				// TODO: Add folder instructions and make it selected
				self.folderName()
					.val('')
					.focus();
			}
		},

		"{createFolderButton} click": function(el)
		{
			self.createFolder();			
		},		

		"{folderName} keyup": function(el, event)
		{
			if (event.keyCode==13)
			{
				self.createFolder();
			}
		}
	}}
);
})(Foundry);