(function($){

$.Controller(
	'EasyBlog.FileManager.Browser.ItemHandler.Upload',
	{
		defaults: {
			'{itemFilesize}': '.item-filesize',
			'{uploadViewButton}': '.upload-view-button',
			'{uploadRemoveButton}': '.upload-remove-button',
			'{uploadStatus}': '.upload-status',
			'@Item': 'EasyBlog.FileManager.Browser.ItemHandler.Upload.Item'
		}
	},
	function(self) { return {

		init: function()
		{
			self.fileManager = self.options.fileManager;

			self.render(function(html)
			{
				self.element
					.html(html);

				self.setState(plupload.QUEUED);
			});
		},

		render: function(callback)
		{
			$.View(
				self.template('Item'),
				self.options.properties,
				function(html)
				{
					return callback && callback.apply(self, [html]);
				}
			);
		},

		setLayout: function()
		{

		},

		history: [],

		log: function(message)
		{
			// Prune duplicates
			if (self.history.slice(-1)[0] && self.history.slice(-1)[0].message == message) return;

			self.history.push({
				timestamp: new Date(),
				message: message
			});

			if (self.previewHandler)
			{
				self.previewHandler.generateLog();
			}
		},

		beforeUpload: function(file)
		{
			if( self.fileManager.options.debug )
			{
				self.log('Initiating upload #' + file.id + '.');
			}

			self.totalSize = file.size;

			self.setState(plupload.STARTED);

			self.setProgress(file.percent);
		},

		uploadFile: function(file)
		{
			self.log( $.lang( 'COM_EASYBLOG_UPLOAD_LOG_UPLOADING' ) + '"' + file.name + '".' );	

			self.setState(plupload.UPLOADING);

			self.setProgress(file.percent);
		},

		uploadProgress: function(file)
		{
			self.log(file.percent + '% ' + $.lang( 'COM_EASYBLOG_UPLOAD_LOG_UPLOADED_PROGRESS' ) + '.' + ((file.loaded!==undefined && file.size!==undefined) ? '[' + file.loaded + '/' + file.size + ']' : '') );

			// uploadProgress event might trigger even after upload is complete
			if (!self.completed || self.pseudoProgress < 100)
				self.setState(plupload.UPLOADING);

			self.setProgress(file.percent);
		},

		chunkUploaded: function(file)
		{
			// Unused for now.
		},

		fileUploaded: function(file, response)
		{
			self.log( $.lang( 'COM_EASYBLOG_UPLOAD_LOG_COMPLETED' ) );
			
			if( self.fileManager.options.debug )
			{
				self.log('Server returned: ' + $.toJSON(response));
			}

			var itemProp = response.item;

			self.fileManager.browser.addItem(itemProp, function(item)
			{
				self.fileItemHandler = item;
			});

			self.setState(plupload.DONE);			

			self.setProgress(file.percent);

			self.completed = true;
		},

		error: function(file, error)
		{
			self.log('Error ' + error.code + '. ' + error.message);

			if (error.details) self.log(error.details);

			self.setState(plupload.FAILED);

			self.completed = true;
		},

		/* plUpload file events */

		//
		// TODO: Calculate rate of progression.
		//
		// Formula is something like:
		// var rateLastDuration = (currentNaturalProgress - lastNaturalProgress) / durationBetweenProgress;
		// var ratePerSecond = rateLastDuration / durationBetweenProgress * 1000;
		// var ratePerCycle = (ratePerSecond / 1000) * cycleDuration;
		//
		// A more accurate calculation involves taking a mean average of ratio history:
		// var ratePerSeconds = [];
		// ratePerSeconds.push(ratePerSecond);
		// totalRate = 0;
		// ratePerSeconds.each(function(i, rate){totalRate+=rate});
		//
		// var preciseRatePerSecond = totalRate / ratePerSeconds.length;
		//

        actualProgress: 0,

        pseudoProgress: 0,

		setProgress: function(val)
		{
			self.actualProgress = val;
				
			(function()
			{
				if ((self.pseudoProgress >= 100 && self.completed) || self._destroyed)
				{
					self.setState(plupload.DONE);
					return;
				}

				// Increment progress by 1% every 250 msec.
				self.pseudoProgress++
				self.pseudoProgress = (self.pseudoProgress > 100) ? 100 : self.pseudoProgress;

				// Update progress on item handler.
				var val = self.pseudoProgress,
					percentage = val + '%',
					sizeSoFar = (self.totalSize=="N/A" || self.totalSize===undefined) ? '': '(' + plupload.formatSize(Math.floor(self.totalSize * (val / 100))) + '/' + plupload.formatSize(self.totalSize) + ')';

				self.itemFilesize()
					.html(percentage + ' ' + sizeSoFar);

				// Update progress bar on preview handler
				if (self.previewHandler)
					self.previewHandler.setProgress(val);
				
				// Update the main toolbar
				self.fileManager.toolbar.upload.setProgress();

				// If actualProgress quicker than pseudoProgress, speed up pseudoProgress;
				var rate = (self.actualProgress > self.pseudoProgress) ? 50 : 250;
				setTimeout(arguments.callee, rate);

			})();
		},

		getState: function()
		{
			return self.state;
		},

		setState: function(state)
		{
			// plupload.STOPPED = 1;
			// plupload.STARTED = 2;
			// plupload.QUEUED = 1;
			// plupload.UPLOADING = 2;
			// plupload.FAILED = 4;
			// plupload.DONE = 5;

			self.state = state;

			self.element
				.removeClass('state-1 state-2 state-4 state-5')
				.addClass('state-'+state);

			if (self.previewHandler)
				self.previewHandler.setState(state);
		},

		"{uploadViewButton} click": function(el, event)
		{
			event.stopPropagation();

			self.fileManager.browser.gotoItem(self.fileItemHandler);
		},

		"{uploadRemoveButton} click": function(el, event)
		{
			event.stopPropagation();

			var id = self.options.properties.id;

			self.fileManager.uploader.remove(id);
		}

	}}
);
})(Foundry);