<?php
/**
* @package		EasyBlog
* @copyright	Copyright (C) 2010 Stack Ideas Private Limited. All rights reserved.
* @license		GNU/GPL, see LICENSE.php
* EasyBlog is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
* See COPYRIGHT.php for copyright notices and details.
*/
defined('_JEXEC') or die('Restricted access');

jimport( 'joomla.application.component.view');
jimport( 'joomla.html.toolbar' );

class EasyBlogViewBlogger extends EasyBlogView
{
	function display( $tmpl = null )
	{
		JPluginHelper::importPlugin( 'easyblog' );

		$dispatcher = JDispatcher::getInstance();
		$mainframe	= JFactory::getApplication();
        $document	= JFactory::getDocument();

		$config = EasyBlogHelper::getConfig();
		$theme = $config->get( 'layout_theme' );

		$my         = JFactory::getUser();
		$acl 		= EasyBlogACLHelper::getRuleSet();

        // set meta tags for bloggers
		EasyBlogHelper::setMeta( META_ID_BLOGGERS, META_TYPE_VIEW );

	    //setting pathway
	    $pathway	= $mainframe->getPathway();
		if( ! EasyBlogRouter::isCurrentActiveMenu( 'blogger' ) )
			$this->setPathway( JText::_('COM_EASYBLOG_BLOGGERS_BREADCRUMB') , '' );

        $sort		= JRequest::getCmd('sort','featured');
        $sortHTML   = $this->_getSorting( $sort );

        $filter		= JRequest::getCmd('filter','showbloggerwithpost');
        $filterHTML = $this->_getFilter( $filter );


        $model		= $this->getModel( 'Blogger' );
		$modelB		= $this->getModel( 'Blog' );
		$modelPT	= $this->getModel( 'PostTag' );

		$search		= JRequest::getString( 'search' , '' );

		$data		= $model->getBloggers($sort, '', $filter , $search );
		$pagination	= $model->getPagination();

		//for trigger
		$params		= $mainframe->getParams('com_easyblog');
		$limitstart	= JRequest::getVar('limitstart', 0, '', 'int');

		$pageTitle	= EasyBlogHelper::getPageTitle( $config->get('main_title') );
		$pageNumber	= $pagination->get( 'pages.current' );
		$pageText	= ($pageNumber == 1) ? '' : ' - ' . JText::sprintf( 'COM_EASYBLOG_PAGE_NUMBER', $pageNumber );
		$document->setTitle( JText::_('COM_EASYBLOG_BLOGGERS_PAGE_TITLE') . $pageText . ' - ' . $pageTitle );

		//now get the blogs for each blogger
		if(! empty($data))
		{
			foreach($data as $blogger )
			{
				$profile	= EasyBlogHelper::getTable( 'Profile', 'Table' );
				$row			= $blogger;

				$profile->load( $row->id );
				$row->blogger	= $profile;
				$entries		= $modelB->getBlogsBy('blogger', $row->id, $config->get( 'layout_postorder' ), 5, EBLOG_FILTER_PUBLISHED);

				//perform formatting and triggering.
				$entries      	= EasyBlogHelper::formatBlog($entries);

				//tags used by blogger.
				$bloggerTags	= $model->getTagUsed($row->id);

				//categories used by blogger.
				$bloggerCategory    = $model->getCategoryUsed($row->id);

				//get twitter follow me link
				$twitterFollowMelink= EasyBlogSocialShareHelper::getLink('twitter', $row->id);

				$row->twitterLink 	= $twitterFollowMelink;
				$row->rssLink		= $profile->getRSS();
				$row->blogs			= $entries;
				$row->tags          = $bloggerTags;
				$row->commentsCount	= ( EasyBlogHelper::getHelper( 'Comment' )->isBuiltin() ) ? $profile->getCommentsCount() : 0;
				$row->categories    = $bloggerCategory;
				$row->blogCount		= $model->getTotalBlogCreated( $row->id );
			}
		}

		$theme	= new CodeThemes();

		$theme->set('config'	, $config );
		$theme->set('data', $data );
		$theme->set( 'search' , $search );
		$theme->set('sort', $sort );
		$theme->set('pagination', $pagination->getPagesLinks());
		$theme->set('siteadmin', EasyBlogHelper::isSiteAdmin() );
		$theme->set('sortHTML', $sortHTML );
		$theme->set( 'currentURL' , 'index.php?option=com_easyblog&view=blogger' );
		$theme->set('filterHTML', $filterHTML );
		$theme->set('my', $my );
		$theme->set('acl', $acl );

		echo $theme->fetch( 'blog.bloggers.php' );
	}

	/*
	 * Show all the blogs in this blogger
	 */
	function listings()
	{
		JPluginHelper::importPlugin( 'easyblog' );
		$dispatcher = JDispatcher::getInstance();
		$mainframe	= JFactory::getApplication();
        $document	= JFactory::getDocument();
        $config 	= EasyBlogHelper::getConfig();
		$my         = JFactory::getUser();
		$acl 		= EasyBlogACLHelper::getRuleSet();
        $sort		= JRequest::getCmd('sort', $config->get( 'layout_postorder' ) );
        $bId		= JRequest::getCmd('id','0');

	    $blogger = EasyBlogHelper::getTable( 'Profile', 'Table' );
	    $blogger->load($bId);

		if(! $config->get('main_nonblogger_profile') )
		{
			if( ! EasyBlogHelper::isBlogger( $blogger->id ) )
			{
				$redirect	= EasyBlogRouter::_( 'index.php?option=com_easyblog&view=latest' , false );
			    $mainframe->redirect($redirect);
			    $mainframe->close();
			}
		}

		EasyBlogHelper::setMeta( $blogger->id, META_TYPE_BLOGGER, true );

		if( ! EasyBlogRouter::isCurrentActiveMenu( 'blogger', $blogger->id ) )
		{
		    if( ! EasyBlogRouter::isCurrentActiveMenu( 'blogger' ) )
				$this->setPathway( JText::_('COM_EASYBLOG_BLOGGERS_BREADCRUMB') , EasyBlogRouter::_('index.php?option=com_easyblog&view=blogger') );

			$this->setPathway( $blogger->getName() );
		}

        $model		= $this->getModel( 'Blog' );
		$data		= $model->getBlogsBy('blogger', $blogger->id, $sort);
		$pagination	= $model->getPagination();
		$data		= EasyBlogHelper::formatBlog($data);
		$rssURL		= EasyBlogRouter::_('index.php?option=com_easyblog&view=blogger&task=rss');

		if($config->get('layout_showcomment', false))
		{
		    for($i = 0; $i < count($data); $i++)
		    {
		        $row   = $data[$i];
				$maxComment = $config->get('layout_showcommentcount', 3);
				$comments	= EasyBlogHelper::getHelper( 'Comment' )->getBlogComment( $row->id, $maxComment , 'desc' );
                $comments   = EasyBlogHelper::formatBlogCommentsLite($comments);
	    		$row->comments = $comments;
		    }
		}

		if( $config->get('main_rss') )
		{
			if( $config->get('main_feedburner') && $config->get('main_feedburnerblogger') )
			{
				$document->addHeadLink( $blogger->getRSS(), 'alternate' , 'rel' , array('type' => 'application/rss+xml', 'title' => 'RSS 2.0') );
			}
			else
			{
			    // Add rss feed link
			    $document->addHeadLink( $blogger->getRSS() , 'alternate' , 'rel' , array('type' => 'application/rss+xml', 'title' => 'RSS 2.0') );
				$document->addHeadLink( $blogger->getAtom() , 'alternate' , 'rel' , array('type' => 'application/atom+xml', 'title' => 'Atom 1.0') );
			}
		}

		$pageTitle	= EasyBlogHelper::getPageTitle($config->get('main_title'));
		$pageNumber	= $pagination->get( 'pages.current' );
		$pageText	= ($pageNumber == 1) ? '' : ' - ' . JText::sprintf( 'COM_EASYBLOG_PAGE_NUMBER', $pageNumber );
		$document->setTitle( $blogger->getName() . $pageText . ' - ' . $pageTitle );

		$theme	= new CodeThemes();
		$theme->set( 'twitterLink'	, $blogger->getTwitterLink() );
		$theme->set( 'blogger'		, $blogger );
		$theme->set( 'sort'			, $sort );
		$theme->set( 'blogs'		, $data );
		$theme->set( 'pagination'	, $pagination->getPagesLinks());
		$theme->set( 'my'			, $my );
		$theme->set( 'acl'			, $acl );
		$theme->set( 'currentURL'	, $blogger->getProfileLink() );
		$theme->set( 'showAvatar'	, false );
		echo $theme->fetch( 'blog.blogger.php' );
		echo EasyBlogHelper::getFBInitScript();
	}

	function statistic()
	{
		JPluginHelper::importPlugin( 'easyblog' );
		$dispatcher = JDispatcher::getInstance();
		$mainframe	= JFactory::getApplication();
        $document	= JFactory::getDocument();
        $config 	= EasyBlogHelper::getConfig();
		$my         = JFactory::getUser();
		$acl 		= EasyBlogACLHelper::getRuleSet();

        $sort	= JRequest::getCmd('sort', $config->get( 'layout_postorder' ) );
        $bId	= JRequest::getCmd('id','0');

        //stats type
        $statType	= JRequest::getString('stat','');
        $statId     = ($statType == 'tag') ? JRequest::getString('tagid','') : JRequest::getString('catid','');

        $statObject = null;
        if($statType == 'category')
        {
            $statObject = EasyBlogHelper::getTable( 'ECategory', 'Table' );
            $statObject->load($statId);
        }
        else
        {
            JTable::addIncludePath( EBLOG_TABLES );
            $statObject = EasyBlogHelper::getTable( 'Tag', 'Table' );
            $statObject->load($statId);
        }

	    $blogger = EasyBlogHelper::getTable( 'Profile', 'Table' );
	    $blogger->load( $bId );

	    // set meta tags for blogger
		EasyBlogHelper::setMeta( $blogger->id, META_TYPE_BLOGGER, true );
		if( ! EasyBlogRouter::isCurrentActiveMenu( 'blogger' ) )
			$this->setPathway( JText::_('COM_EASYBLOG_BLOGGERS') , EasyBlogRouter::_('index.php?option=com_easyblog&view=blogger') );

		if( ! EasyBlogRouter::isCurrentActiveMenu( 'blogger', $blogger->id ) )
			$this->setPathway( $blogger->getName() );

        $model		= $this->getModel( 'Blog' );
		$data		= $model->getBlogsBy('blogger', $blogger->id, $sort);
		$pagination	= $model->getPagination();

		$data		= EasyBlogHelper::formatBlog($data);
		$rssURL		= EasyBlogRouter::_('index.php?option=com_easyblog&view=blogger&task=rss');

		if($config->get('layout_showcomment', false))
		{
		    for($i = 0; $i < count($data); $i++)
		    {
		        $row   = $data[$i];

				$maxComment = $config->get('layout_showcommentcount', 3);
				$comments	= EasyBlogHelper::getHelper( 'Comment' )->getBlogComment( $row->id, $maxComment , 'desc' );
                $comments   = EasyBlogHelper::formatBlogCommentsLite($comments);
	    		$row->comments = $comments;
		    }
		}

		$twitterFollowMelink= EasyBlogSocialShareHelper::getLink('twitter', $blogger->id);

		if( $config->get('main_rss') )
		{
			if( $config->get('main_feedburner') && $config->get('main_feedburnerblogger') )
			{
			$document->addHeadLink( $blogger->getRSS() , 'alternate' , 'rel' , array('type' => 'application/rss+xml', 'title' => 'RSS 2.0') );
			}
			else
			{
			    // Add rss feed link
			    $document->addHeadLink( $blogger->getRSS() , 'alternate' , 'rel' , array('type' => 'application/rss+xml', 'title' => 'RSS 2.0') );
				$document->addHeadLink( $blogger->getAtom() , 'alternate' , 'rel' , array('type' => 'application/atom+xml', 'title' => 'Atom 1.0') );
			}
		}

		$pageTitle	= EasyBlogHelper::getPageTitle($config->get('main_title'));
		$pageNumber	= $pagination->get( 'pages.current' );
		$pageText	= ($pageNumber == 1) ? '' : ' - ' . JText::sprintf( 'COM_EASYBLOG_PAGE_NUMBER', $pageNumber );

		$statTitle	= '';
		if ( isset($statType) )
		{
			if ( $statType == 'tag' )
			{
				$statTitle	= ' - ' . JText::sprintf( 'COM_EASYBLOG_BLOGGER_STAT_TAG' , $statObject->title);
			}
			else
			{
				$statTitle = ' - ' . JText::sprintf('COM_EASYBLOG_BLOGGER_STAT_CATEGORY', $statObject->title);
			}
		}

		$document->setTitle($blogger->getName() . $statTitle . $pageText . ' - ' . $pageTitle);

		$tpl	= new CodeThemes();
		$tpl->set('blogger', $blogger );
		$tpl->set('sort', $sort );
		$tpl->set('blogs', $data );
		$tpl->set('config', $config );
		$tpl->set('siteadmin', EasyBlogHelper::isSiteAdmin() );
		$tpl->set('pagination', $pagination->getPagesLinks());
		$tpl->set('twitterFollowMelink', $twitterFollowMelink);
		$tpl->set('my', $my );
		$tpl->set('acl', $acl );
		$tpl->set( 'currentURL'	, ltrim( '/' , JRequest::getURI() ) );

		$tpl->set('statType', $statType );
		$tpl->set('statObject', $statObject );

		echo $tpl->fetch( 'blog.blogger.php' );
	}

	function _getSorting($sorting_type = 'featured')
	{
		$filter[] = JHTML::_('select.option', 'featured', JText::_('COM_EASYBLOG_SORT_BY_FEATURED_BLOGGERS') );
		$filter[] = JHTML::_('select.option', 'latestpost', JText::_('COM_EASYBLOG_SORT_BY_LATEST_POST') );
		$filter[] = JHTML::_('select.option', 'latest', JText::_('COM_EASYBLOG_SORT_BY_LATEST_BLOGGER') );

		return JHTML::_('select.genericlist', $filter, 'sort', 'size="1"', 'value', 'text', $sorting_type );
	}

	function _getFilter($filter_type = 'showbloggerwithpost')
	{
		$filter[] = JHTML::_('select.option', 'showbloggerwithpost', JText::_('COM_EASYBLOG_FILTERS_BLOGGER_WITH_POST') );
		$filter[] = JHTML::_('select.option', 'showallblogger', JText::_('COM_EASYBLOG_FILTERS_ALL_BLOGGERS') );

		return JHTML::_('select.genericlist', $filter, 'filter', 'size="1"', 'value', 'text', $filter_type );
	}
}
