<?php
/**
 * @package		EasyBlog
 * @copyright	Copyright (C) 2010 Stack Ideas Private Limited. All rights reserved.
 * @license		GNU/GPL, see LICENSE.php
 *  
 * EasyBlog is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 * See COPYRIGHT.php for copyright notices and details.
 */

defined('_JEXEC') or die('Restricted access');

$homeItemId = EasyBlogRouter::getItemid( 'latest' );
?>
<?php if($system->config->get('layout_enabledashboardtoolbar')) : ?>
<div id="topbar" class="clearfix">
	<ul class="ui-toolbar reset-ul float-li clearfix">
		<?php if($system->config->get('layout_dashboardhome')) { ?>
		<li class="dashboard">
			<a href="<?php echo EasyBlogRouter::_('index.php?option=com_easyblog&view=latest&Itemid=' . $homeItemId); ?>"><span class="ir"><?php echo JText::_('COM_EASYBLOG_DASHBOARD_TOOLBAR_HOME'); ?></span></a>
		</li>
		<?php } ?>
	    <?php if($system->config->get('layout_dashboardmain')) { ?>
	    <li class="posts<?php echo $current == 'display' ? ' active' : ''; ?>">
	    	<a href="<?php echo EasyBlogRouter::_('index.php?option=com_easyblog&view=dashboard'); ?>"><span><?php echo JText::_('COM_EASYBLOG_DASHBOARD_TOOLBAR_OVERVIEW'); ?></span></a>
	    </li>
		<?php } ?>

		<?php if($system->config->get('layout_dashboardblogs')) { ?>
			<?php if(($this->acl->rules->publish_entry) || ($this->acl->rules->add_entry) || ($this->acl->rules->delete_entry)) { ?>
			<li class="posts<?php echo $current == 'entries' ? ' active' : ''; ?>">
				<a href="<?php echo EasyBlogRouter::_('index.php?option=com_easyblog&view=dashboard&layout=entries'); ?>"><span><?php echo JText::_('COM_EASYBLOG_DASHBOARD_TOOLBAR_POSTS'); ?></span></a>
			</li>
			<?php } ?>
			
			<?php // the user pending view should reuse this layout_dashboardblogs checking. ?>
			<li class="posts<?php echo $current == 'review' ? ' active' : ''; ?>">
				<a href="<?php echo EasyBlogRouter::_('index.php?option=com_easyblog&view=dashboard&layout=review'); ?>"><span><?php echo JText::_('COM_EASYBLOG_DASHBOARD_TOOLBAR_REVIEW'); ?></span></a>
			</li>
		<?php } ?>

		<?php if($system->config->get('layout_dashboarddrafts')) { ?>
			<?php if(($this->acl->rules->publish_entry) || ($this->acl->rules->add_entry) || ($this->acl->rules->delete_entry)) { ?>
			<li class="drafts<?php echo $current == 'drafts' ? ' active' : ''; ?><?php echo ( $totalDrafts > 0 ) ? ' hasdraft' : '';?>">
				<a href="<?php echo EasyBlogRouter::_('index.php?option=com_easyblog&view=dashboard&layout=drafts'); ?>">
					<span><?php echo JText::_('COM_EASYBLOG_DASHBOARD_TOOLBAR_DRAFTS'); ?></span>
					<?php if( $totalDrafts > 0 ){ ?>
					<sup><?php echo $totalDrafts; ?></sup>
					<?php } ?>
				</a>
			</li>
			<?php } ?>
		<?php } ?>

		<?php if($system->config->get('layout_dashboardcomments') && $this->acl->rules->manage_comment && EasyBlogHelper::getHelper( 'Comment')->isBuiltin() ) : ?>
		<li class="comments<?php echo $current == 'comments' ? ' active' : ''; ?>">
			<a href="<?php echo EasyBlogRouter::_('index.php?option=com_easyblog&view=dashboard&layout=comments'); ?>"><span><?php echo JText::_('COM_EASYBLOG_DASHBOARD_TOOLBAR_COMMENTS'); ?></span></a>
		</li>
		<?php endif; ?>

		<?php if($system->config->get('layout_dashboardcategories') && $this->acl->rules->create_category) : ?>
		<li class="categories<?php echo $current == 'categories' ? ' active' : ''; ?>">
			<a href="<?php echo EasyBlogRouter::_('index.php?option=com_easyblog&view=dashboard&layout=categories'); ?>"><span><?php echo JText::_('COM_EASYBLOG_DASHBOARD_TOOLBAR_CATEGORIES'); ?></span></a>
		</li>
		<?php endif; ?>

		<?php if($system->config->get('layout_dashboardtags') && $this->acl->rules->create_tag) : ?>
		<li class="tags<?php echo $current == 'tags' ? ' active' : ''; ?>">
			<a href="<?php echo EasyBlogRouter::_('index.php?option=com_easyblog&view=dashboard&layout=tags'); ?>"><span><?php echo JText::_('COM_EASYBLOG_DASHBOARD_TOOLBAR_TAGS'); ?></span></a>
		</li>
		<?php endif; ?>
		
        <?php if($isTeamAdmin && $totalTeamRequest > 0 ) : ?>
        <li class="teamblog">
            <a href="<?php echo EasyBlogRouter::_('index.php?option=com_easyblog&view=dashboard&layout=teamblogs'); ?>">
                <span class="ir"><?php echo JText::_('COM_EASYBLOG_DASHBOARD_TOOLBAR_TEAMREQUEST'); ?></span>
                <sup><?php echo ($totalTeamRequest > 0) ? $totalTeamRequest  : 0; ?></sup>
            </a>
        </li>
        <?php endif; ?>

        <?php if( !empty($this->acl->rules->manage_pending) && !empty($this->acl->rules->publish_entry) && $totalPending > 0 ){ ?>
        <li class="review">
            <a href="<?php echo EasyBlogRouter::_('index.php?option=com_easyblog&view=dashboard&layout=pending&id=' . $user->id ); ?>" title="<?php echo $this->getNouns( 'COM_EASYBLOG_PENDING_REVIEW' , $totalPending , true); ?>">
                <span class="ir"><?php echo JText::_('COM_EASYBLOG_DASHBOARD_TOOLBAR_PENDING_REVIEW'); ?></span>
                <sup><?php echo ($totalPending > 0) ? $totalPending : 0 ?></sup>
            </a>
        </li>
        <?php } ?>

        <?php
        /*
        * All links below will be floated to the right
        */
        ?>
        <li class="sign-out float-r">
			<a class="logout" href="javascript:sQuery('#eblog-logout').submit();" title="<?php echo JText::_('COM_EASYBLOG_DASHBOARD_TOOLBAR_SIGNOUT'); ?>"><span class="ir"><?php echo JText::_('COM_EASYBLOG_DASHBOARD_TOOLBAR_SIGN_OUT'); ?></span></a>
			<form id="eblog-logout" action="<?php echo JRoute::_($logoutActionLink); ?>" method="post">
				<input type="hidden" value="<?php echo $logoutURL; ?>" name="return">
				<?php echo JHTML::_( 'form.token' ); ?>
			</form>
        </li>

        <?php if($system->config->get('layout_dashboardsettings') && $system->config->get('layout_option_toolbar') ) : ?>
        <li class="settings<?php echo $current == 'profile' ? ' active' : ''; ?> cog float-r">
			<a href="<?php echo EasyBlogRouter::_('index.php?option=com_easyblog&view=dashboard&layout=profile'); ?>" title="<?php echo JText::_('COM_EASYBLOG_DASHBOARD_TOOLBAR_EDIT_PROFILE'); ?>">
                <span class="ir"><?php echo JText::_('COM_EASYBLOG_DASHBOARD_TOOLBAR_EDIT_PROFILE'); ?></span>
            </a>
		</li>
        <?php endif; ?>
        <?php if( $system->config->get('layout_dashboardnewpost') && $this->acl->rules->add_entry ){ ?>
        <li class="new-post float-r<?php echo $current == 'write' ? ' active' : '';?>">
            <a href="<?php echo EasyBlogRouter::_('index.php?option=com_easyblog&view=dashboard&layout=write'); ?><?php echo ($system->config->get( 'layout_dashboardanchor' ) ) ? '#write-entry' : '';?>">
                <span><?php echo JText::_('COM_EASYBLOG_DASHBOARD_TOOLBAR_NEW_POST'); ?></span>
            </a>
        </li>
        <?php } ?>
	</ul>
</div>
<?php endif; ?>