<?php
/**
 * @package		EasyBlog
 * @copyright	Copyright (C) 2010 Stack Ideas Private Limited. All rights reserved.
 * @license		GNU/GPL, see LICENSE.php
 *  
 * EasyBlog is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 * See COPYRIGHT.php for copyright notices and details.
 */
defined('_JEXEC') or die('Restricted access');
?>
<div id="write_container">
    <?php if( $system->config->get( 'layout_dashboardstats') ){ ?>
    <div class="ui-modbox" class="widget-stats">
        <div class="ui-modhead">
        	<div class="ui-modtitle"><?php echo JText::_('COM_EASYBLOG_DASHBOARD_STATISTICS_PAGE_HEADING'); ?></div>
        	<a href="javascript:void(0);" onclick="eblog.dashboard.toggle( this );" class="ui-tog pabs atr ir"><?php echo JText::_( 'COM_EASYBLOG_HIDE' );?></a>
        </div>
        <div class="ui-modbody clearfix">
            <ul class="reset-ul float-li ui-3col ui-statinfo">
                <li>
                    <span class="stat-info"><?php echo $blogStat->blog; ?></span>
                    <span><?php echo $this->getNouns( 'COM_EASYBLOG_DASHBOARD_POST_COUNT' , $blogStat->blog );?></span>
                </li>
                <li>
                    <span class="stat-info"><?php echo $blogStat->category; ?></span>
                    <span><?php echo $this->getNouns( 'COM_EASYBLOG_DASHBOARD_CATEGORIES_COUNT' , $blogStat->category );?></span>
                </li>
                <li>
                    <span class="stat-info"><?php echo $blogStat->tag; ?></span>
                    <span><?php echo $this->getNouns( 'COM_EASYBLOG_DASHBOARD_TAGS_COUNT' , $blogStat->tag );?></span>
                </li>
                <?php if(! $system->config->get('comment_intensedebate') && !$system->config->get('comment_disqus') && !$system->config->get('comment_jomcomment') && !$system->config->get('comment_jcomments') && !$system->config->get('comment_rscomments')) : ?>
                <li>
                    <span class="stat-info"><?php echo $blogStat->comment; ?></span>
                    <span><?php echo $this->getNouns( 'COM_EASYBLOG_DASHBOARD_COMMENTS_COUNT' , $blogStat->comment );?></span>
                </li>
                <?php endif; ?>
                <li>
                    <span class="stat-info"><?php echo $blogStat->subscriber; ?></span>
                    <span><?php echo $this->getNouns( 'COM_EASYBLOG_DASHBOARD_SUBSCRIBERS_COUNT' , $blogStat->subscriber );?></span>
                </li>
                <?php if($system->config->get('layout_teamblog')) : ?>
                <li>
                    <span class="stat-info"><?php echo $blogStat->team; ?></span>
                    <span><?php echo $this->getNouns( 'COM_EASYBLOG_DASHBOARD_TEAMS_COUNT' , $blogStat->subscriber );?></span>
                </li>
                <?php endif; ?>
            </ul>
        </div>
    </div>
    <?php } ?>
    
    <?php if( $system->config->get( 'layout_dashboardquickpost' ) ){ ?>
	<?php echo $this->fetch( 'dashboard.quick.post.php' ); ?>
	<?php } ?>
</div>

