<?php
/**
 * @package		EasyBlog
 * @copyright	Copyright (C) 2010 Stack Ideas Private Limited. All rights reserved.
 * @license		GNU/GPL, see LICENSE.php
 *
 * EasyBlog is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 * See COPYRIGHT.php for copyright notices and details.
 */

defined('_JEXEC') or die('Restricted access');

require_once( EBLOG_HELPERS . DS . 'helper.php' );

class EjaxLoader
{
	/**
	 * Function to add js file, js script block and css file
	 * to HEAD section
	 */
	public static function _( $list, $type='js', $location='assets' )
	{
		$document	= JFactory::getDocument();
		$config		= EasyBlogHelper::getConfig();

		// Always load mootools first so it will not conflict.
		JHTML::_('behavior.mootools');

		$files 	= explode( ',', $list );
		$dir	= JURI::root() . 'components/com_easyblog/assets';
		$theme	= $config->get( 'layout_theme' );
		$version	= str_ireplace( '.' , '' , EasyBlogHelper::getLocalVersion() );

		if ( $location != 'assets' && !$location = null  )
		{
			$dir	= JURI::root() . 'components/com_easyblog/themes/' . $theme;
		}

		foreach( $files as $file )
		{
			if ( $type == 'js' )
			{
				$document->addScript( $dir . '/js/' . $file . '.js?' . $version );
			}
			elseif ( $type == 'css' )
			{
				$document->addStylesheet( $dir . '/css/' . $file . '.css');
			}
		}
	}
}
