<?php
/*--------------------------------------------------------------*\
	Description:	HTML template class.
	Author:			Brian Lozier (brian@massassi.net)
	License:		Please read the license.txt file.
	Last Updated:	11/27/2002
\*--------------------------------------------------------------*/

/**
 * @package		EasyBlog
 * @copyright	Copyright (C) 2010 Stack Ideas Private Limited. All rights reserved.
 * @license		GNU/GPL, see LICENSE.php
 *
 * EasyBlog is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 * See COPYRIGHT.php for copyright notices and details.
 */

defined('_JEXEC') or die('Restricted access');

require_once( EBLOG_HELPERS . DS . 'tooltip.php' );
require_once( EBLOG_HELPERS . DS . 'date.php' );
require_once( EBLOG_HELPERS . DS . 'string.php' );
require_once( EBLOG_HELPERS . DS . 'router.php' );

class CodeThemes
{
	// Holds all the template variables
	var $vars;

	// Determines whether the current browser is a dashboard or not.
	var $dashboard = false;

	// User selected theme
	var $user_theme = '';

	/**
	 * Pass theme name from config
	 */
	function CodeThemes( $sel_theme = null )
	{
		$config = EasyBlogHelper::getConfig();

		$this->user_theme	= $config->get( 'layout_theme' );

		// Default theme
		$theme				= 'default';

		if ( empty($sel_theme) )
		{
			$theme = $config->get( 'layout_theme' );
		}
		elseif ( $sel_theme == 'dashboard' )
		{
			$theme	= $config->get( 'layout_dashboard_theme' );
			$this->dashboard = true;
		}
		$this->_theme	= $theme;

		$obj			= new stdClass();
		$obj->config	= EasyBlogHelper::getConfig();
		$obj->my		= JFactory::getUser();
		$obj->admin		= EasyBlogHelper::isSiteAdmin();

		$profile    = EasyBlogHelper::getTable( 'Profile','Table');
		$profile->load($obj->my->id);
		$profile->setUser($obj->my);
		$obj->profile	= $profile;

		//is blogger mode flag
		$obj->isBloggerMode	= EasyBlogRouter::isBloggerMode();

		$this->set( 'system' , $obj );
		$this->acl		= EasyBlogACLHelper::getRuleSet();
	}

	function getDirection()
	{
		$document	= JFactory::getDocument();
		return $document->getDirection();
	}

	function getNouns( $text , $count , $includeCount = false )
	{
		return EasyBlogStringHelper::getNoun( $text , $count , $includeCount );
	}

	function chopString( $string , $length )
	{
		return JString::substr( $string , 0 , $length );
	}

	function formatDate( $format , $dateString )
	{
		$date	= EasyBlogDateHelper::dateWithOffSet($dateString);
		return EasyBlogDateHelper::toFormat($date, $format);
	}

	/**
	 * Set a template variable.
	 */
	function set($name, $value)
	{
		$this->vars[$name] = $value;
	}

	public function getName()
	{
		return $this->_theme;
	}

	/**
	 * Open, parse, and return the template file.
	 *
	 * @param $file string the template file name
	 */
	function fetch( $file )
	{
		jimport( 'joomla.filesystem.file' );

		$mainframe = JFactory::getApplication();

		// Overrides. Browser can choose different template after load
		$override	= JRequest::getWord( 'theme' , '' );

		if( $override )
		{
			$this->_theme	= $override;
		}

		// load the file based on the theme's config.ini
		// @since 1.1.x
		$info 			= EasyBlogHelper::getThemeInfo( $this->_theme );

		/**
		 * Precedence in order.
		 * 1. Template override
		 * 2. Selected theme
		 * 3. Parent theme
		 * 4. Default system theme
		 */
		if ( !$this->dashboard )
		{
			$overridePath	= JPATH_ROOT . DS . 'templates' . DS . $mainframe->getTemplate() . DS . 'html' . DS . 'com_easyblog' . DS . $file;
			$selectedPath	= EBLOG_THEMES . DS . $this->_theme . DS . $file;
			$parentPath		= EBLOG_THEMES . DS . $info->get( 'parent' ) . DS . $file;
			$defaultPath	= EBLOG_THEMES . DS . 'default' . DS . $file;
		}
		/**
		 * The dashboard theme
		 */
		else
		{
			$overridePath	= JPATH_ROOT . DS . 'templates' . DS . $mainframe->getTemplate() . DS . 'html' . DS . 'com_easyblog' . DS . 'dashboard' . DS . $file;
			$selectedPath	= EBLOG_THEMES . DS . 'dashboard' . DS . $this->_theme . DS . $file;
			$parentPath		= EBLOG_THEMES . DS . 'dashboard' . DS . $info->get( 'parent' ) . DS . $file;
			$defaultPath	= EBLOG_THEMES . DS . 'dashboard' . DS . 'system' . DS . $file;
		}

		// 1. Template overrides
		if( JFile::exists( $overridePath ) )
		{
			$file	= $overridePath;
		}
		// 2. Selected themes
		elseif( JFile::exists( $selectedPath ) )
		{
			$file	= $selectedPath;
		}
		// 3. Parent themes
		elseif( JFile::exists( $parentPath ) )
		{
			$file	= $parentPath;
		}
		// 4. Default system theme
		else
		{
			$file	= $defaultPath;
		}

		if( isset( $this->vars ) )
		{
			extract($this->vars);
		}

		ob_start();

		if( !JFile::exists( $file ) )
		{
			echo JText::sprintf( 'Invalid template file %1s' , $file );
		}
		else
		{
			include($file);
		}
		$data		= ob_get_contents();
		ob_end_clean();

		return $data;
	}

	/*
	 * Renders a nice checkbox switch.
	 *
	 * @param	string	$option		Name attribute for the checkbox.
	 * @param	string	$sate		State of the checkbox, checked or not.
	 * @return	string	HTML output.
	 */
	public function renderCheckbox( $option , $state )
	{
		ob_start();
	?>
		<div class="si-optiontap">
			<label class="option-enable<?php echo $state == 1 ? ' selected' : '';?>"><span><?php echo JText::_( 'COM_EASYBLOG_NO_SWITCH' );?></span></label>
			<label class="option-disable<?php echo $state == 0 ? ' selected' : '';?>"><span><?php echo JText::_( 'COM_EASYBLOG_YES_SWITCH' ); ?></span></label>
			<input name="<?php echo $option; ?>" value="<?php echo $state;?>" type="radio" class="radiobox" checked="checked" style="display: none;" />
		</div>
	<?php
		$html	= ob_get_contents();
		ob_end_clean();

		return $html;
	}

	public function json_encode( $value )
	{
		include_once( EBLOG_CLASSES . DS . 'json.php' );
		$json	= new Services_JSON();

		return $json->encode( $value );
	}

	public function json_decode( $value )
	{
		include_once( EBLOG_CLASSES . DS . 'json.php' );
		$json	= new Services_JSON();

		return $json->decode( $value );
	}

	function escape( $val )
	{
		return EasyBlogStringHelper::escape( $val );
	}
}
