<?php
/**
 * @package		EasyBlog
 * @copyright	Copyright (C) 2010 Stack Ideas Private Limited. All rights reserved.
 * @license		GNU/GPL, see LICENSE.php
 *  
 * EasyBlog is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 * See COPYRIGHT.php for copyright notices and details.
 */

defined('_JEXEC') or die('Restricted access');

require_once( EBLOG_CLASSES . DS . 'themes.php' );

class ENotification
{		
	function ENotification()
	{
		//constructor
	}
	
	function getAdminEmails()
	{
		$db		=& JFactory::getDBO();
		
		$query	= 'SELECT `name`, `email`';
		$query	.= ' FROM #__users';
		
		if(EasyBlogHelper::getJoomlaVersion() >= '1.6')
		{
		    $saUsersIds	= EasyBlogHelper::getSAUsersIds();
		    $query	.= ' WHERE id IN (' . implode(',', $saUsersIds) . ')';
		}
		else
		{
			$query	.= ' WHERE LOWER( `usertype` ) = ' . $db->Quote('super administrator');
		}
		
		$query	.= ' AND `sendEmail` = ' . $db->Quote('1');
		$db->setQuery( $query );

		if($db->getErrorNum()) {
			JError::raiseError( 500, $db->stderr());
		}

		$result = $db->loadObjectList();
		return $result;		
	}
	
	function getAdmins()
	{
		$db	=& JFactory::getDBO();

		$query	= 'SELECT `id`';
		$query	.= ' FROM #__users';
		
		if(EasyBlogHelper::getJoomlaVersion() >= '1.6')
		{
		    $saUsersIds	= EasyBlogHelper::getSAUsersIds();
		    $query	.= ' WHERE id IN (' . implode(',', $saUsersIds) . ')';
		}
		else
		{
			$query	.= ' WHERE LOWER( `usertype` ) = ' . $db->Quote('super administrator');
		}
		$query	.= ' AND `sendEmail` = ' . $db->Quote('1');

		$db->setQuery( $query );

		if($db->getErrorNum()) {
			JError::raiseError( 500, $db->stderr());
		}

		$result = $db->loadObjectList();
		return $result;
	}

	function sendEmails($toEmails, $subject = '', $body = '', $template='', $data = array())
	{
		JTable::addIncludePath( JPATH_ROOT . DS . 'administrator' . DS . 'components' . DS . 'com_easyblog' . DS . 'tables' );
		
		$mainframe	=& JFactory::getApplication();
		$mailfrom	= $mainframe->getCfg( 'mailfrom' );
		$fromname 	= $mainframe->getCfg( 'fromname' );

		$emailTo	= array();
		
		if(is_array($toEmails))
		{
			foreach($toEmails as $email)
			{
			    $emailTo[]  = $email;
			}
		}
		else
		{
			$emailTo[]	= $toEmails;
		}

		$tplBody	= '';
		if(! empty($template))
		{
			if(!isset($data['unsubscribeLink']))
			{
				$data['unsubscribeLink'] = '';
			}
		
			$tplBody	= $this->getEmailTemplateContent( $template, $data );
		}
		else
		{
			$tplBody	= $body;
		}

		//now we process the email sending.
		foreach($emailTo as $recipient)
		{
			// Porcess the message and title
			$search 	= array('{actor}', '{target}');
			$replace 	= array($fromname, '');

			$emailSubject 	= JString::str_ireplace($search, $replace, $subject);
			$emailBody 		= JString::str_ireplace($search, $replace, $tplBody);

			//JUtility::sendMail($mailfrom, $fromname, $recipient->email, $emailSubject, $emailBody);
			$date   =& JFactory::getDate();
			$mailq	=& EasyBlogHelper::getTable( 'MailQueue', 'Table' );

			$mailq->mailfrom	= $mailfrom;
			$mailq->fromname	= $fromname;
			$mailq->recipient	= $recipient;
			$mailq->subject   	= $emailSubject;
			$mailq->body		= $emailBody;
			$mailq->created		= $date->toMySQL();
			$mailq->store();
		}

	}
	
	function send($from='', $to, $subject = '', $body = '', $template='', $data = array())
	{
		JTable::addIncludePath( JPATH_ROOT . DS . 'administrator' . DS . 'components' . DS . 'com_easyblog' . DS . 'tables' );
		
		$mainframe	=& JFactory::getApplication();
		$mailfrom	= $mainframe->getCfg( 'mailfrom' );
		$fromname 	= $mainframe->getCfg( 'fromname' );			
		
		
		if(! empty($from))
		{
			$userFrom	= JFactory::getUser($from);
			if($userFrom->id != 0)
			{
				$mailfrom	= $userFrom->name;
				$fromname 	= $userFrom->email;			
			}	
		}
		
		
		$userTo	= array();
		if(! is_array($to))
		{
		    if(strtolower($to) == 'admin')
		    {
				$to	= $this->getAdmins();
				
				foreach($to as $ids)
				{
					$user		=& JFactory::getUser($ids->id);
					$userTo[]	= $user;
				}
				
			}
		}
		else
		{
			if(is_array($to))
			{
				foreach($to as $ids)
				{
					$user		=& JFactory::getUser($ids);
					$userTo[]	= $user;			
				}			
			}
			else
			{
				$user		=& JFactory::getUser($to);
				$userTo[]	= $user;	
			}		
		}
		
		//load the email template
		$tplBody	= '';
		if(! empty($template))
		{
			// unsubscribe link is only available to subscriber's email.
			if(!isset($data['unsubscribeLink']))
			{
				$data['unsubscribeLink'] = '';
			}
			
			$tplBody	= $this->getEmailTemplateContent( $template, $data );
		}
		else
		{
			$tplBody	= $body;
		}
		
		//now we process the email sending.
		foreach($userTo as $recipient)
		{

		    $recipientUser	=& EasyBlogHelper::getTable( 'Profile', 'Table' );
		    $recipientUser->setUser($recipient);
					
			// Porcess the message and title
			$search 	= array('{actor}', '{target}');
			$replace 	= array($fromname, $recipientUser->getName());
			
			$emailSubject 	= JString::str_ireplace($search, $replace, $subject);
			$emailBody 		= JString::str_ireplace($search, $replace, $tplBody);
			
			//JUtility::sendMail($mailfrom, $fromname, $recipient->email, $emailSubject, $emailBody);
			$date   =& JFactory::getDate();
			$mailq	=& EasyBlogHelper::getTable( 'MailQueue', 'Table' );
			
			$mailq->mailfrom	= $mailfrom;
			$mailq->fromname	= $fromname;
			$mailq->recipient	= $recipient->email;
			$mailq->subject   	= $emailSubject;
			$mailq->body		= $emailBody;
			$mailq->created		= $date->toMySQL();
			$mailq->store();
		}
						
	}
	
	function getEmailTemplateContent( $template, $data )
	{
	    $tplBody    = '';
	
		if(!isset($data['unsubscribeLink']))
		{
			$data['unsubscribeLink'] = '';
		}

		$theme	= new CodeThemes();
		
		foreach( $data as $key => $val )
		{
			$theme->set( $key , $val );
		}

		return $theme->fetch( $template );
	}
	
	public function notifyAdmins( $title , $body , $template , $data )
	{
		$config			= EasyBlogHelper::getConfig();
		$emails			= $config->get( 'notification_email' );
		
		if( !empty( $emails ) )
		{
			$emails	= explode( ',' , $config->get( 'notification_email' ) );
			$this->sendEmails( $emails , $title , $body , $template , $data );
			return true;
		}
		
		$this->send( '' , 'admin' , $title , $body , $template , $data );
		return true;
	}
}
