<?php
/**
 * @package		EasyBlog
 * @copyright	Copyright (C) 2010 Stack Ideas Private Limited. All rights reserved.
 * @license		GNU/GPL, see LICENSE.php
 *
 * EasyBlog is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 * See COPYRIGHT.php for copyright notices and details.
 */

defined('_JEXEC') or die('Restricted access');

require_once( EBLOG_HELPERS . DS .'helper.php' );

class EasyBlogFacebookLikes
{
	public static function getLikeHTML( $row )
	{
		$config	= EasyBlogHelper::getConfig();

		if( !$config->get('main_facebook_like') )
		{
			return '';
		}


		$views		= JRequest::getCmd(	'view' , '');
		$layout		= JRequest::getCmd( 'layout' , '' );

		if( ! $config->get('integrations_facebook_show_in_listing') )
		{
			if($views == 'latest' || $views == 'blogger' || $layout == 'tag' || ( $views == 'categories' && $layout == 'listings' ) )
			{
				return '';
			}
		}
		$document	= JFactory::getDocument();
		$language	= $document->getLanguage();
		$language	= explode( '-' , $language );

		if( count( $language ) != 2 )
		{
			$language	= array( 'en' , 'GB' );
		}

		$layout		= $config->get('main_facebook_like_layout');
		$faces		= $config->get('main_facebook_like_faces') ? 'true' : 'false';
		$width		= $config->get('main_facebook_like_width');
		$verb		= $config->get('main_facebook_like_verb' );
		$theme		= $config->get('main_facebook_like_theme' );
		$send		= $config->get( 'main_facebook_like_send' ) ? 'true' : 'false';

		$sbPosition		= $config->get('main_socialbutton_position' );
		$fbPosition		= $config->get('main_facebook_like_position' );

		if( $fbPosition == '1' )
		{
			$faces  = false;
		}


		//var_dump($row);exit;

		$teamIdLink = '';
		if( isset( $row->team ) )
			$teamIdLink = '&team=' . $row->team;

		require_once( EBLOG_HELPERS . DS . 'router.php' );
		$url		= EasyBlogRouter::getRoutedURL( 'index.php?option=com_easyblog&view=entry&id=' . $row->id . $teamIdLink , true , true );

		// if the layout == box_count, the we hard code it to 50 the with.
		$height     = ($faces == 'true') ? '70' : '30';
		$width      = ($layout == 'standard') ? $width : '50';


		if( $layout != 'standard' && $send == 'true' && $sbPosition != 'right' && $sbPosition != 'left')
		{
			$width	= '200';
		}

		$locale     = $language[0] . '_' . JString::strtoupper( $language[1] );

		$html 		= '';

		if( $config->get( 'main_facebook_scripts' , 1 ) )
		{
			$html		.= '<div id="fb-root"></div><script src="https://connect.facebook.net/' . $locale . '/all.js#xfbml=1"></script>';
		}

		$html 		.= '<fb:like href="' . $url . '" send="' . $send . '" layout="' . $layout . '" action="' . $verb . '" '
					. 'locale="' . $locale . '" colorscheme="' . $theme . '" show_faces="' . $faces . '" style="height: ' . $height . 'px;width:' . $width . 'px;" height="' . $height . '" width="' . $width . '"></fb:like>';

		return $html;
	}
}
