<?php

/*
// Simple META Management Suite for Joomla 1.5.x - Version 1.5.4 [Dragonbane]
//
// Licence:
//		AGPLv3 - http://www.aqsg.com.au/products/simple-meta-management-suite/licence.html
//
// Author:
//		Joel Bassett - http://www.aqsg.com.au
//
// Credits:
//		http://www.aqsg.com.au/products/simple-meta-management-suite/credits.html
*/

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

// Import library dependencies
jimport('joomla.application.component.model');
jimport( 'joomla.environment.uri' );

class SMMSInstallModelSettings extends JModel {
	var $_settings = null;

	function &getInstance( $type = 'model', $prefix = '', $config = array() ) {
		static $instance;
		
		if(!is_object($instance)) {
			$instance = new SMMSInstallModelSettings();	
		}
		
		return $instance;
	}
	
	function __construct($config = array()) {
		parent::__construct();
		
		$session =& JFactory::getSession();
		$this->_loadSettings();
	}

	function reload() {
		$session =& JFactory::getSession();
		$this->_loadSettings();		
	}

	function get($key, $default = null) {
		if(is_null($this->_settings)) {
			$this->_loadSettings();
		}

		if(isset($this->_settings[$key])) {
			return $this->_settings[$key];
		} else {
			$default = is_null($default) ? $this->_getDefaultFor($key) : $default;
			$this->_settings[$key] = $default;
			return $default;
		}
	}
	
	function set($key, $value) {
		$this->_settings[$key] = $value;			
	}

	function save() {
		$db = JFactory::getDBO();
		
		$query = '';

		foreach($this->_settings as $key => $value) {
			$query .= 'UPDATE ' . $db->nameQuote('#__smms_settings') . ' SET ' . $db->nameQuote('value') . ' = ' . $db->Quote($value) . ' WHERE ' . $db->nameQuote('key') . ' = ' . $db->Quote($key) . ' LIMIT 1;' . "\n";
			//$query .= 'DELETE FROM '.$db->nameQuote('#__smms_settings').
			//		' WHERE '.$db->nameQuote('key').' = '.$db->Quote($key).';'."\n";
			//$query .= 'INSERT INTO '.$db->nameQuote('#__smms_settings').
			//		'('.$db->nameQuote('key').','.$db->nameQuote('value').')'.
			//		' VALUES '.
			//		'('.$db->Quote($key).','.$db->Quote($value).');'."\n";
		}

		$db->setQuery($query);
		$db->queryBatch(true,true);
	}

	function bindFromData(&$data) {
		if(!is_array($data)) {
			JError::raiseError('500', JText::_('MODELPROFILE_ERROR_BINDING'));
			return false;
		}
		
		foreach($data as $key => $value) {
			$this->set($key, $value);
		}
		return true;
	}

	function &getRawsettingsArray() {
		return $this->_settings;
	}

	function _loadSettings() {	
		$db =& JFactory::getDBO();
		$query =  'SELECT ' . $db->nameQuote('key') . ',' . $db->nameQuote('value')
				. ' FROM ' . $db->nameQuote('#__smms_settings');
		$db->setQuery($query);
		$tmp = $db->loadAssocList();
		$this->_settings = array();
		if( is_array($tmp) ) foreach($tmp as $entry) {
			$this->_settings[$entry['key']] = $entry['value'];
		}
		unset($tmp);
	}
	
	function _getDefaultFor($key) {
		switch($key) {
			case 'core_version':
				$default = '1.5.4';
				break; 

			case 'core_productCodename':
				$default = 'Draghkar';
				break;

			case 'core_stopcollectingurls':
				$default = '0';
				break;

			default:
				$default = 'default';
				break;				
		}
		return $default;
	}
}

?>