<?php

/*
// Simple META Management Suite for Joomla 1.5.x - Version 1.5.4 [Dragonbane]
//
// Licence:
//		AGPLv3 - http://www.aqsg.com.au/products/simple-meta-management-suite/licence.html
//
// Author:
//		Joel Bassett - http://www.aqsg.com.au
//
// Credits:
//		http://www.aqsg.com.au/products/simple-meta-management-suite/credits.html
*/

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

class SimpleMETAManagementFunctions_tools {
	function optimiseDatabase() {
		$db			= & JFactory::getDBO();
		$msg = JText::_( 'SMMS_TOOLS_MESSAGE_DATABASEOPTIMISED' ) . "<br />";
		$tables = array(
						"#__smms_address",
						"#__smms_categories",
						"#__smms_defaults",
						"#__smms_description",
						"#__smms_feeds",
						"#__smms_keywords",
						"#__smms_miscmeta",
						"#__smms_modules",
						"#__smms_replace",
						"#__smms_settings",
						"#__smms_stopwords"
						);
		
		foreach ($tables as $table) {
			$query = "OPTIMIZE TABLE " . $table;
			$db->setQuery($query);
			if (!$db->query())
				$msg .= "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;FAIL : " . $table . " <br />";
			else
				$msg .= "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;SUCCESS : " . $table . " <br />";
		}
		return $msg;
	}

	function clearDatabase() {
		$db			= & JFactory::getDBO();
		$msg 		= JText::_('SMMS_TOOLS_MESSAGE_DATABASECLEARED');
		$tables = array(
						"#__smms_address",
						"#__smms_description",
						"#__smms_feeds",
						"#__smms_keywords",
						"#__smms_miscmeta",
						"#__smms_replace"
						);
		
		foreach ($tables as $table) {
			$query = "TRUNCATE TABLE " . $table;
			$db->setQuery($query);
			if (!$db->query())
				$msg .= "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;FAIL : " . $table . " <br />";
			else
				$msg .= "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;SUCCESS : " . $table . " <br />";
		}
		return $msg;
	}

	function resetDatabase() {
		$db			= & JFactory::getDBO();
		$msg 		= JText::_( 'SMMS_TOOLS_MESSAGE_DATABASERESET' ) . "<br />";

		$query	= 'SELECT'
				. ' m.name AS name'
				. ', m.databasename AS database'
				. ', m.databasefield AS field'
				. ' FROM #__smms_modules AS m'
				. ' WHERE m.enabled = 1'
				. ' ORDER BY m.id';						
		$db->setQuery($query);
		$results = $db->loadObjectList();
		if (count($results) != 0)
			foreach ($results as $row) {
				$query 		= 'SELECT id FROM ' . $db->nameQuote($row->database) . ' WHERE ' . $db->nameQuote(strstr($row->field, '.')) . ' <> 0';			
				$db->setQuery($query);
				$affectedrows = $db->loadObjectList();
				foreach ($affectedrows as $affectedrow) {
					$query = 'UPDATE ' . $db->nameQuote($row->database) . ' SET ' . $db->nameQuote(strstr($row->field, '.')) . ' = ' . $db->Quote('0') . ' WHERE id = \''. $affectedrow->id .'\'';
					$db->setQuery($query);
					if (!$db->query())
						$failrow = $failrow + 1;
					else
						$succeedrow = $succeedrow + 1;
				}
				
				$msg .= "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" . $row->database . " : Succeeded on " . $succeedrow . " records <br />";
				$msg .= "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" . $row->database . " : Failed on " . $failrow . " records <br />";				
			}
			
		return $msg;
	}
	

	function displayDatabaseManagement() {
		$settings 		=& JComponentHelper::getParams('com_smms');
		$filename		= date("Ymd-H:i:s");
		
		echo "<table class=\"adminform\">\n";
		echo "	<tr>\n";
		echo "		<td>\n";
		echo "			<label for=\"database_optimise\"><b>\n";
		echo 				JText::_( 'SMMS_TOOLS_LABEL_OPTIMISEDATABASE' );
		echo "			</label>\n";
		echo "		</td>\n";
		echo "		<td>\n";
		echo 			SimpleMETAManagementFunctions_Common::simplebooleanlist('database_optimise', '', '0');;
		echo "		</td>\n";
		echo "	</tr>\n";
		echo "	<tr>\n";
		echo "		<td>\n";
		echo "			<label for=\"database_reset\"><b>\n";
		echo 				JText::_( 'SMMS_TOOLS_LABEL_RESETDATABASE' );
		echo "			</label>\n";
		echo "		</td>\n";
		echo "		<td>\n";
		echo 			SimpleMETAManagementFunctions_Common::simplebooleanlist('database_reset', '', '0');
		echo "		</td>\n";
		echo "		<td>\n";
		echo "		</td>\n";
		echo "		<td>\n";
		echo "		</td>\n";
		echo "	</tr>\n";
		echo "	<tr>\n";
		echo "		<td>\n";
		echo "			<label for=\"database_clear\"><b>\n";
		echo 				JText::_( 'SMMS_TOOLS_LABEL_CLEARDATABASE' );
		echo "			</label>\n";
		echo "		</td>\n";
		echo "		<td>\n";
		echo 			SimpleMETAManagementFunctions_Common::simplebooleanlist('database_clear', '', '0');
		echo "		</td>\n";
		echo "		<td>\n";
		echo "			<b><font style=\"font-color: red;\">\n";
		echo 				JText::_( 'SMMS_TOOLS_LABEL_CLEARDATABASE_CONFIRM' );
		echo "			</font>\n";
		echo "		</td>\n";
		echo "		<td>\n";
		echo "		</td>\n";
		echo "	</tr>\n";
		echo "	<tr>\n";
		echo "		<td>&nbsp;\n";
		echo "		</td>\n";
		echo "	</tr>\n";
		echo "</table>\n";
	}
}

?>