<?php

/*
// Simple META Management Suite for Joomla 1.5.x - Version 1.5.4 [Dragonbane]
//
// Licence:
//		AGPLv3 - http://www.aqsg.com.au/products/simple-meta-management-suite/licence.html
//
// Author:
//		Joel Bassett - http://www.aqsg.com.au
//
// Credits:
//		http://www.aqsg.com.au/products/simple-meta-management-suite/credits.html 
*/

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

// Import library dependencies
jimport( 'joomla.filesystem.folder' );
jimport( 'joomla.filesystem.file' );

class SimpleMETAManagementFunctions_default
{
	function installedSMMSExtensions() {
		$extensions[] = 'manageurls';
		$extensions[] = 'categories';
		$extensions[] = 'defaultvalues';
		$extensions[] = 'findandreplace';
		
		return $extensions;
	}

	function installedOtherExtensions() {
		$extensions[] = 'tools';
		$extensions[] = 'extensions';
		$extensions[] = 'settings';
		
		return $extensions;
	}

	function buildMenu($extensionname) {
		$extensiontext = 'SMMS_PAGE_' . strtoupper($extensionname);
		echo "\t<div class=\"icon\">\n";
		echo "\t\t<a href=\"index.php?option=" . JRequest::getCmd('option','com_smms') . "&amp;view=" . $extensionname . "\">\n";
		echo "\t\t\t<img src=\"" . JURI::base() . "components/" . JRequest::getCmd('option','com_smms') . "/assets/images/" . $extensionname . ".png\" border=\"0\" alt=\"" . JText::_( $extensiontext ) . "\" />\n <br />";
		echo "\t\t\t<span>" . JText::_( $extensiontext ) . "</span>\n";
		echo "\t\t</a>\n";
		echo "\t</div>\n";
	}
	
	function getStatistics() {
		$db		=& JFactory::getDBO();

		$query 	= 'SELECT COUNT(*) FROM #__smms_address';
		$db->setQuery( $query );
		$statistics->totalURLs = $db->loadResult();
		
		$query = 'SELECT COUNT(*) FROM #__smms_categories WHERE enabled = 1';
		$db->setQuery( $query );
		$statistics->totalCategories = $db->loadResult();
	
		$query = 'SELECT COUNT(*) FROM #__smms_replace WHERE replace_enabled = 1';
		$db->setQuery( $query );
		$statistics->totalFindAndReplace = $db->loadResult();

		$query = 'SELECT COUNT(*) FROM #__smms_modules WHERE enabled = 1';
		$db->setQuery( $query );
		$statistics->totalModules = $db->loadResult();

		return $statistics;
	}
	
	function getCategoryStatistics() {
		$categories 	= array();
		$db				=& JFactory::getDBO();
		
		$query	= 'SELECT'
			. ' name AS name'
			. ', id AS id'
			. ', enabled AS enabled'
			. ' FROM #__smms_categories'
			. ' ORDER BY enabled DESC, name';						
		$db->setQuery($query);
		$results = $db->loadObjectList();
		
		return $results;
	}
	
	function buildCategoryStatistics() {
		$db				=& JFactory::getDBO();
		$categories 	= SimpleMETAManagementFunctions_default::getCategoryStatistics();
		
		echo "<table class=\"adminForm\" width=\"100%\" cellpadding=\"5\">\n";
		echo "<tr>\n";
		echo "<th style=\"border-bottom: 2px solid #005000;\"><b>" . JText::_( 'SMMS_CONTROLPANEL_TABLE_TITLE') . "</b></th>\n";
		echo "<th style=\"border-bottom: 2px solid #005000;\"><b>" . JText::_( 'SMMS_CONTROLPANEL_TABLE_URLS') . "</b></th>\n";
		echo "</tr>\n";
		foreach ($categories as $category) {
			$query = 'SELECT COUNT(*) FROM #__smms_address WHERE categoryid = \'' . $category->id . '\'';
			$db->setQuery( $query );
			$categoryvalue = $db->loadResult();
			if ($odd) {
				echo "<tr bgcolor=\"#F4F4F4\">\n";
				$odd = 0;
			} else {
				echo "<tr bgcolor=\"#EFEFEF\">\n";
				$odd = 1;			
			}
			 if ($category->enabled)
				echo "<td style=\"color: #039517;\">" . $category->name . "</td>\n";
			else
				echo "<td style=\"color: #97010F;\">" . $category->name . "</td>\n";
			
			echo "<td align=\"center\">" . $categoryvalue . "</td>\n";
			echo "</tr>\n";
		}
		echo "</table>\n";
	}

	function getInstalledModules() {
		$db			=& JFactory::getDBO();
		$query	= 'SELECT'
			. ' name AS name'
			. ', enabled AS enabled'
			. ' FROM #__smms_modules'
			. ' ORDER BY enabled DESC, name';						
		$db->setQuery($query);
		$modules = $db->loadObjectList();

		foreach ($modules as $module) {
			if ($module->enabled)
				$installedmodules .= "<font color=\"#039517\">mod_" . $module->name . "</font><br />\n";
			else
				$installedmodules .= "<font color=\"#97010F\">mod_" . $module->name . "</font><br />\n";
		}
		return $installedmodules;
	}
	
	function buildProductInformation() {

		$db			=& JFactory::getDBO();
		$settings 	=& SMMSModelSettings::getInstance();
		
		$productInformation->version 		= $settings->get('core_version', 0);
		$productInformation->releasedate 	= $settings->get('core_releaseDate', 0);
		$productInformation->codename 		= $settings->get('core_productCodename', 0);
		$productInformation->modules 		= SimpleMETAManagementFunctions_default::getInstalledModules();
	
		echo "<table class=\"adminForm\" width=\"100%\" cellpadding=\"5\">\n";
		
		echo "<tr bgcolor=\"#F4F4F4\">\n";
		echo "<td><b>" . JText::_( 'SMMS_CONTROLPANEL_TABLE_VERSION') . "</b></td>\n";
		echo "<td align=\"center\">" . $productInformation->version . " [" . $productInformation->codename . "] </td>\n";
		echo "</tr>\n";

		echo "<tr bgcolor=\"#EFEFEF\">\n";
		echo "<td><b>" . JText::_( 'SMMS_CONTROLPANEL_TABLE_RELEASEDATE') . "</b></td>\n";
		echo "<td align=\"center\">" . $productInformation->releasedate . "</td>\n";
		echo "</tr>\n";

		echo "<tr bgcolor=\"#F4F4F4\">\n";
		echo "<td><b>" . JText::_( 'SMMS_CONTROLPANEL_TABLE_INSTALLEDMODULES') . "</td>\n";
		echo "<td align=\"left\">" . $productInformation->modules . "</td>\n";
		echo "</tr>\n";
		
		echo "<tr bgcolor=\"#EFEFEF\">\n";
		echo "<td><b>" . JText::_( 'SMMS_CONTROLPANEL_TABLE_LICENCE') . "</td>\n";
		echo "<td align=\"center\"><a href=\"http://www.aqsg.com.au/products/simple-meta-management-suite/licence.html\" title=\"AGPLv3\ target=\"_blank\"><img src=\"" . JURI::base() . "components/" . JRequest::getCmd('option','com_smms') . "/assets/images/agplv3.png\" alt=\"AGPLv3\" /></a></td>\n";
		echo "</tr>\n";
		
		echo "</table>\n";
	}

	function buildProductRegistration()
	{
		$settings 							=& SMMSModelSettings::getInstance();
		$productInformation->registration 	= $settings->_pK();
		echo "<table class=\"adminForm\" width=\"100%\" cellpadding=\"5\">\n";
		echo "<tr bgcolor=\"#F4F4F4\">\n";
		echo "<td align=\"center\">";
		switch ($productInformation->registration) {
			case "2":
				$imgname = "udc";
				break;
				
			case "1":
				$imgname = "sdc";
				break;

			default:
				$imgname = "unregistered";
				break;
		}
		echo "<img src=\"" . JURI::base() . "components/" . JRequest::getCmd('option','com_smms') . "/assets/images/" . $imgname . ".png\" />";
		echo "</td>\n";
		echo "</tr>\n";
		echo "</table>\n";
	}
}

?>