<?php

/*
// Simple META Management Suite for Joomla 1.5.x - Version 1.5.4 [Dragonbane]
//
// Licence:
//		AGPLv3 - http://www.aqsg.com.au/products/simple-meta-management-suite/licence.html
//
// Author:
//		Joel Bassett - http://www.aqsg.com.au
//
// Credits:
//		http://www.aqsg.com.au/products/simple-meta-management-suite/credits.html
*/

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

class SimpleMETAManagementFunctions_common {
	function sterilisetext($in_text) {
		$in_text = str_replace("'", "&#39;", $in_text);
		$in_text = str_replace('"', "&#34;", $in_text);
		$in_text = str_replace('\\', "&#92;", $in_text);
		$in_text = str_replace('/', "&#47;", $in_text);
		return $in_text;
	}

	function unsterilisetext($in_text) {
		$in_text = preg_replace("/&#39;/", "'", $in_text);
		$in_text = preg_replace("/&#34;/", "\"", $in_text);
		$in_text = str_replace("&#47;", "/", $in_text);
		return $in_text;
	}

    function selected( &$selection, $i, $title = NULL, $imgY = 'tick.png', $imgX = 'publish_x.png', $imgM = 'disabled.png', $imgD = 'publish_g.png') {
        $img	= $selection ? $imgY : $imgX;
        switch ($selection) {
			case "1":
				$img = $imgY;
				if ($title) {
					$action	= $title;
					$alt	= $title;
				} else {
					$action	= JText::_( 'SMMS_GLOBAL_MESSAGE_ACTIVE' );
					$alt	= JText::_( 'SMMS_GLOBAL_MESSAGE_ACTIVE' );
				}
				break;
				
			case "2":
				$img = $imgM;
				if ($title) {
					$action	= JText::_( 'SMMS_GLOBAL_MESSAGE_REMOVED' ) . ': ' . $title;
					$alt	= JText::_( 'SMMS_GLOBAL_MESSAGE_REMOVED' ) . ': ' . $title;
				} else {
					$action	= JText::_( 'SMMS_GLOBAL_MESSAGE_REMOVED' );
					$alt	= JText::_( 'SMMS_GLOBAL_MESSAGE_REMOVED' );
				}
				break;

			case "3":
				$img = $imgD;
				if ($title) {
					$action	= JText::_( 'SMMS_GLOBAL_MESSAGE_USINGDEFAULT' );
					$alt	= JText::_( 'SMMS_GLOBAL_MESSAGE_USINGDEFAULT' );
				} else {
					$action	= JText::_( 'SMMS_GLOBAL_MESSAGE_USINGDEFAULT' );
					$alt	= JText::_( 'SMMS_GLOBAL_MESSAGE_USINGDEFAULT' );
				}
				break;

			default:
				$img = $imgX;
				if ($title) {
					$action	= JText::_( 'SMMS_GLOBAL_MESSAGE_NOTACTIVE' ) . ': ' . $title;
					$alt	= JText::_( 'SMMS_GLOBAL_MESSAGE_NOTACTIVE' ) . ': ' . $title;
				} else {
					$action	= JText::_( 'SMMS_GLOBAL_MESSAGE_NOTACTIVE' );
					$alt	= JText::_( 'SMMS_GLOBAL_MESSAGE_NOTACTIVE' );
				}
				break;
		}

		$href	= '<a href="javascript:void(0);" title="'. $action .'"><img src="images/'. $img .'" border="0" alt="'. $alt .'" /></a>';
        return $href;
    }

	function booleanlist($name, $attribs = null, $selected = null, $yes='SMMS_GLOBAL_BOOLEAN_YES', $no='SMMS_GLOBAL_BOOLEAN_NO', $remove='SMMS_GLOBAL_BOOLEAN_REMOVE', $usedefault='SMMS_GLOBAL_BOOLEAN_USEDEFAULT',$id=false) {
		$arr = array(
			JHTML::_('select.option',  '1', JText::_( $yes ) ),
			JHTML::_('select.option',  '0', JText::_( $no ) ),
			JHTML::_('select.option',  '2', JText::_( $remove ) ),
			JHTML::_('select.option',  '3', JText::_( $usedefault ) )
		);
		return SimpleMETAManagementFunctions_Common::radiolist($arr, $name, $attribs, 'value', 'text', (int) $selected, $id );
	}

	function simplebooleanlist($name, $attribs = null, $selected = null, $yes='SMMS_GLOBAL_BOOLEAN_YES', $no='SMMS_GLOBAL_BOOLEAN_NO', $id=false) {
		$arr = array(
			JHTML::_('select.option',  '1', JText::_( $yes ) ),
			JHTML::_('select.option',  '0', JText::_( $no ) ),
		);
		return SimpleMETAManagementFunctions_Common::radiolist($arr, $name, $attribs, 'value', 'text', (int) $selected, $id );
	}

	function radiolist($arr, $name, $attribs = null, $key = 'value', $text = 'text', $selected = null, $idtag = false, $translate = false ) {
		reset( $arr );
		$html = '';

		if (is_array($attribs)) {
			$attribs = JArrayHelper::toString($attribs);
		}

		$id_text = $name;
		if ( $idtag ) {
			$id_text = $idtag;
		}

		for ($i=0, $n=count( $arr ); $i < $n; $i++ ) {
			$k	= $arr[$i]->$key;
			$t	= $translate ? JText::_( $arr[$i]->$text ) : $arr[$i]->$text;
			$id	= ( isset($arr[$i]->id) ? @$arr[$i]->id : null);

			$extra	= '';
			$extra	.= $id ? " id=\"" . $prefix . $arr[$i]->id . "\"" : '';
			if (is_array( $selected )) {
				foreach ($selected as $val) {
					$k2 = is_object( $val ) ? $val->$key : $val;
					if ($k == $k2) {
						$extra .= " selected=\"selected\"";
						break;
					}
				}
			} else {
				$extra .= ((string)$k == (string)$selected ? " checked=\"checked\"" : '');
			}
			$html .= "\n\t<input type=\"radio\" name=\"" . $name . "\" id=\"" . $id_text . $k . "\" value=\"" . $k . "\"$extra $attribs />";
			$html .= "\n\t<label for=\"$id_text$k\">$t</label>";
		}
		$html .= "\n";
		return $html;
	}
}

?>